// Copyright 1997-2003 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//

@class NSArray, NSMutableArray, NSDictionary, NSNotification, NSString, NSUserDefaults;
@class NSBox, NSTextField, NSView, NSPrintInfo;

#import "MCModelEditor.h"

#import <AppKit/NSNibDeclarations.h> // For IBOutlet

@interface OAPreferenceClient : MCModelEditor
{
	NSString *title;
    NSMutableArray *preferences;
    NSUserDefaults *defaults;
}

- initWithTitle:(NSString *)newTitle defaultsArray:(NSArray *)newDefaultsArray;

- (void)addPreference: (NSDictionary *) preference;

- (BOOL)canDisplayPreferenceInContext:(id)context verbose:(BOOL)verb;

// default is NO, subclasses that print can return YES; Subclasses must then implement runPrintOperationWithPrintInfo: showPanels:
- (BOOL)canPrintInContext:(id)context;

- (void)resetFloatValueToDefaultNamed:(NSString *)defaultName inTextField:(NSTextField *)textField;
- (void)resetIntValueToDefaultNamed:(NSString *)defaultName inTextField:(NSTextField *)textField;

// This is an action, so don't change its type
- (IBAction)restoreDefaults:(id)sender;
- (void)restoreDefaultsNoPrompt;
- (BOOL)haveAnyDefaultsChanged;

// Allows the preference client the chance to prevent the preference pane and/or window from going away
- (BOOL)shouldResignCurrentEditor;

- (void)pickDirectoryForTextField:(NSTextField *)textField;

// The default implementations of these methods do nothing:  each subclass is expected to implement them.
- (void)setValueForSender:(id)sender;
    
// These are public so they can be subclassed.
- (void)valuesHaveChanged;
- (void)controlTextDidEndEditing:(NSNotification *)notification;


@end
